/*
 * Decompiled with CFR 0.152.
 */
package updater;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.HashMap;

public class Digest {
    private String filename;

    public Digest(String filename) {
        this.filename = filename;
    }

    public String getFilename() {
        return this.filename;
    }

    public void make() {
        this.make(new File("."));
    }

    public void make(File root) {
        block5: {
            File file = new File(this.filename);
            File backup = new File(String.valueOf(this.filename) + "_backup");
            if (file.exists()) {
                if (backup.exists()) {
                    backup.delete();
                }
                file.renameTo(backup);
            }
            try {
                BufferedWriter bw = new BufferedWriter(new FileWriter(file));
                this.make(root, bw);
                bw.close();
                if (backup.exists()) {
                    backup.delete();
                }
                file.deleteOnExit();
            }
            catch (Exception e) {
                if (!backup.exists()) break block5;
                file.delete();
                backup.renameTo(file);
                backup.deleteOnExit();
            }
        }
    }

    private void make(File root, BufferedWriter bw) {
        if (!root.exists() || !root.isDirectory()) {
            return;
        }
        File[] fileArray = root.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File currentFile = fileArray[n2];
            if (currentFile.isDirectory()) {
                this.make(currentFile, bw);
            } else if (!currentFile.getName().equals(String.valueOf(this.filename) + "_backup")) {
                try {
                    bw.write(String.valueOf(Digest.file2md5(currentFile)) + " " + currentFile.getPath());
                    bw.newLine();
                }
                catch (Exception e) {
                    System.out.println("Fail to hash " + currentFile.getPath());
                }
            }
            ++n2;
        }
    }

    public HashMap<String, String> parse() throws Exception {
        return this.parse(new File(this.filename));
    }

    public HashMap<String, String> parse(File src) throws Exception {
        String line;
        BufferedReader br = new BufferedReader(new FileReader(src));
        HashMap<String, String> mapFiles = new HashMap<String, String>();
        while ((line = br.readLine()) != null) {
            line = line.trim();
            int index = line.indexOf(32);
            if (line.length() <= 34 || index <= 0) continue;
            mapFiles.put(line.substring(index + 1), line.substring(0, index));
        }
        return mapFiles;
    }

    public static String file2md5(File file) throws Exception {
        int len;
        MessageDigest md = MessageDigest.getInstance("MD5");
        FileInputStream in = new FileInputStream(file);
        byte[] buf = new byte[8192];
        while ((len = ((InputStream)in).read(buf)) != -1) {
            md.update(buf, 0, len);
        }
        ((InputStream)in).close();
        byte[] bytes = md.digest();
        StringBuilder sb = new StringBuilder(2 * bytes.length);
        byte[] byArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            sb.append("0123456789ABCDEF".charAt((b & 0xF0) >> 4));
            sb.append("0123456789ABCDEF".charAt(b & 0xF));
            ++n2;
        }
        return sb.toString();
    }

    protected void print() {
        try {
            HashMap<String, String> mapFiles = this.parse();
            for (String key : mapFiles.keySet()) {
                System.out.println(String.valueOf(key) + " -> " + mapFiles.get(key));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

