/*
 * Decompiled with CFR 0.152.
 */
package updater;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import updater.FileDownload;
import updater.FileDownloadListener;

public class FileDownloadHelper {
    private List<FileDownloadListener> listeners = new ArrayList<FileDownloadListener>();
    private File tempDir;

    public FileDownloadHelper(File tempDir) {
        this.tempDir = tempDir;
    }

    public File getTempDir() {
        return this.tempDir;
    }

    public boolean addFileDownloadListener(FileDownloadListener o) {
        return this.listeners.add(o);
    }

    public boolean removeFileDownloadListener(FileDownloadListener o) {
        return this.listeners.remove(o);
    }

    public File downloadFile(URL url, File dest) throws Exception {
        FileDownload download = new FileDownload(url, dest);
        for (FileDownloadListener listener : this.listeners) {
            download.addFileDownloadListener(listener);
        }
        download.performDownload();
        return dest;
    }
}

