/*
 * Decompiled with CFR 0.152.
 */
package wakeupserver;

import java.io.File;
import java.net.ServerSocket;
import java.nio.file.Paths;
import java.util.prefs.Preferences;
import javax.swing.UIManager;
import org.boris.winrun4j.AbstractService;
import org.boris.winrun4j.ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import wakeupserver.ServerManager;
import wakeupserver.SystemTrayFrame;

public class Main
extends AbstractService {
    protected static final Logger log = LoggerFactory.getLogger(Main.class);
    private static ServerManager server;
    private static SystemTrayFrame systemTray;
    private static ServerSocket socket;

    @Override
    public int serviceMain(String[] args) throws ServiceException {
        Main.startServerIfNeeded(true);
        server.startChannel();
        while (!this.shutdown) {
            try {
                Thread.sleep(2000L);
                if (!server.requestShutdown()) continue;
                this.shutdown = true;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.shutdown) {
            server.stop(true);
            server.closeChannel();
            System.exit(0);
        }
        return 0;
    }

    public static void main(String[] args) {
        boolean minimized = false;
        if (args.length > 0) {
            if (args[0].equals("uninstall")) {
                Preferences prefs = SystemTrayFrame.getPrefs();
                prefs.remove("x");
                prefs.remove("y");
                prefs.remove("w");
                prefs.remove("h");
                prefs.remove("l");
                prefs.remove("password");
                prefs.remove("username");
                prefs.remove("port");
                prefs.remove("autoupdate");
                try {
                    prefs.sync();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                System.exit(0);
            }
            if (args[0].equals("minimized")) {
                minimized = true;
            }
        }
        Main.validateRun();
        boolean isService = Main.isService();
        log.debug("Service: " + isService);
        if (!isService) {
            Main.startServerIfNeeded(isService);
        }
        Main.initGUI(isService, minimized);
    }

    public static boolean isService() {
        return new File(Paths.get("WakeUpService.exe", new String[0]).toAbsolutePath().toUri()).exists();
    }

    public static boolean userAuthNoneEnabled() {
        return new File(Paths.get("enableUserAuthNone", new String[0]).toAbsolutePath().toUri()).exists();
    }

    private static void validateRun() {
        try {
            socket = new ServerSocket(1000);
            socket.getLocalPort();
        }
        catch (Exception e) {
            System.exit(1);
        }
    }

    public static void unvalidateRun() {
        try {
            socket.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void startServerIfNeeded(boolean isService) {
        if (server == null) {
            server = new ServerManager(isService);
        }
        if (!server.isRunning()) {
            server.start();
        }
    }

    private static void initGUI(boolean isService, boolean minimized) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (systemTray == null) {
            systemTray = new SystemTrayFrame(isService ? null : server, isService);
            systemTray.setup(!isService && minimized);
            if (!isService) {
                server.setDelegate(systemTray);
            }
        }
    }
}

