/*
 * Decompiled with CFR 0.152.
 */
package wakeupserver;

import com.sun.jna.platform.win32.W32Service;
import com.sun.jna.platform.win32.W32ServiceManager;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ServiceStatusWrapper {
    public static final int SERVICE_UNKNOWN_ERROR = -1;
    public static final int SERVICE_NOT_INSTALLED_ERROR = -1060;
    public static final int SERVICE_BOOT_START = 0;
    public static final int SERVICE_SYSTEM_START = 1;
    public static final int SERVICE_AUTO_START = 2;
    public static final int SERVICE_DEMAND_START = 3;
    public static final int SERVICE_DISABLED = 4;
    public static final int SERVICE_STOPPED = 1;
    public static final int SERVICE_START_PENDING = 2;
    public static final int SERVICE_STOP_PENDING = 3;
    public static final int SERVICE_RUNNING = 4;
    public static final int SERVICE_CONTINUE_PENDING = 5;
    public static final int SERVICE_PAUSE_PENDING = 6;
    public static final int SERVICE_PAUSED = 7;
    private static final Set<String> startType = new HashSet<String>(Arrays.asList("0boot_start", "1system_start", "2auto_start", "3demand_start", "4disabled"));

    private static W32Service getService(String serviceName) {
        try {
            W32ServiceManager serviceManager = new W32ServiceManager();
            serviceManager.open(983103);
            return serviceManager.openService(serviceName, 983103);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static int getState(String serviceName) {
        block12: {
            W32Service service = ServiceStatusWrapper.getService(serviceName);
            if (service != null) break block12;
            return -1060;
        }
        try {
            switch (ServiceStatusWrapper.getService((String)serviceName).queryStatus().dwCurrentState) {
                case 1: {
                    return 1;
                }
                case 2: {
                    return 2;
                }
                case 3: {
                    return 3;
                }
                case 4: {
                    return 4;
                }
                case 5: {
                    return 5;
                }
                case 6: {
                    return 6;
                }
                case 7: {
                    return 7;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return -1;
    }

    public static boolean isRunning(String serviceName) {
        try {
            return ServiceStatusWrapper.getService((String)serviceName).queryStatus().dwCurrentState == 4;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static boolean isInstalled(String serviceName) {
        try {
            return ServiceStatusWrapper.getService(serviceName) != null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static void startService(String serviceName) {
        try {
            W32Service service = ServiceStatusWrapper.getService(serviceName);
            service.startService();
            service.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void stopService(String serviceName) {
        try {
            W32Service service = ServiceStatusWrapper.getService(serviceName);
            service.stopService();
            service.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static int getStartType(String service) {
        return ServiceStatusWrapper.query(service, "qc", "start_type");
    }

    public static boolean isAuto(String service) {
        return ServiceStatusWrapper.getStartType(service) == 2;
    }

    private static int query(String service, String cmd, String key) {
        int query = -1;
        try {
            String s;
            Runtime rt = Runtime.getRuntime();
            String[] commands = new String[]{"sc.exe", cmd, service};
            Process proc = rt.exec(commands);
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            BufferedReader stdError = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
            while ((s = stdInput.readLine()) != null) {
                if (s.toLowerCase().trim().startsWith("[sc]") && s.indexOf(58) >= 0) {
                    s = s.toLowerCase().substring(s.indexOf(58));
                    Pattern p = Pattern.compile("\\d+");
                    Matcher m = p.matcher(s);
                    if (!m.find()) continue;
                    query = -1 * Integer.parseInt(m.group());
                    continue;
                }
                if (s.indexOf(58) < 0) continue;
                s = s.toLowerCase().substring(s.indexOf(58) + 1).trim().replaceAll("\\s", "");
                if (!key.equalsIgnoreCase("start_type") || !startType.contains(s)) continue;
                query = ServiceStatusWrapper.query(s);
            }
            while ((s = stdError.readLine()) != null) {
                System.out.println(s);
            }
            stdInput.close();
            stdError.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return query;
    }

    private static int query(String s) {
        Pattern p = Pattern.compile("\\d+");
        Matcher m = p.matcher(s);
        try {
            if (m.find()) {
                return Integer.parseInt(m.group());
            }
            return -1;
        }
        catch (Exception e) {
            return -1;
        }
    }
}

