/*
 * Decompiled with CFR 0.152.
 */
package wakeupserver;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.prefs.Preferences;
import org.apache.sshd.server.PasswordAuthenticator;
import org.apache.sshd.server.session.ServerSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import wakeupserver.Main;
import wakeupserver.SystemTrayFrame;

public class SshServerPasswordAuthenticator
implements PasswordAuthenticator {
    protected static final Logger log = LoggerFactory.getLogger(Main.class);
    private static final String defaultPassword = "21232f297a57a5a743894a0e4a801fc3";

    @Override
    public boolean authenticate(String username, String password, ServerSession arg2) {
        log.info("LOCAL: Username is " + SshServerPasswordAuthenticator.getUsername() + " and hash password is " + SshServerPasswordAuthenticator.getPassword());
        log.info("RECEIVED: Username is " + username + " and hash password is " + SshServerPasswordAuthenticator.hashPassword(password));
        if (username == null || password == null) {
            return false;
        }
        return SshServerPasswordAuthenticator.hashPassword(password).equals(SshServerPasswordAuthenticator.getPassword()) && username.equals(SshServerPasswordAuthenticator.getUsername());
    }

    public static String getPassword() {
        Preferences prefs = SystemTrayFrame.getPrefs(SshServerPasswordAuthenticator.isService());
        return prefs.get("password", defaultPassword);
    }

    public static String getPasswordField() {
        Preferences prefs = SystemTrayFrame.getPrefs(SshServerPasswordAuthenticator.isService());
        int l = prefs.getInt("l", 5);
        StringBuffer stringBuffer = new StringBuffer(l);
        int i = 0;
        while (i < l) {
            stringBuffer.append('a');
            ++i;
        }
        return stringBuffer.toString();
    }

    public static String getUsername() {
        Preferences prefs = SystemTrayFrame.getPrefs(SshServerPasswordAuthenticator.isService());
        return prefs.get("username", "admin");
    }

    public static String hashPassword(String password) {
        String hashword = "";
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(password.getBytes());
            BigInteger hash = new BigInteger(1, md5.digest());
            hashword = hash.toString(16);
        }
        catch (NoSuchAlgorithmException e) {
            log.error("Error", e);
        }
        return hashword;
    }

    private static boolean isService() {
        return Main.isService();
    }
}

