/*
 * Decompiled with CFR 0.152.
 */
package wakeupserver;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import wakeupserver.Main;
import wakeupserver.PowrProf;
import wakeupserver.SystemTrayFrame;

public class WakeupCommand
implements Command,
Runnable {
    protected static final Logger log = LoggerFactory.getLogger(WakeupCommand.class);
    protected static final int OK = 0;
    protected static final int WARNING = 1;
    protected static final int ERROR = 2;
    protected String name;
    protected ExitCallback callback;

    public WakeupCommand(String[] args) {
        this.name = Arrays.asList(args).toString();
        log.info("Executing command {}", (Object)this.name);
    }

    @Override
    public void destroy() {
    }

    @Override
    public void setErrorStream(OutputStream arg0) {
    }

    @Override
    public void setExitCallback(ExitCallback callback) {
        this.callback = callback;
    }

    @Override
    public void setInputStream(InputStream arg0) {
    }

    @Override
    public void setOutputStream(OutputStream arg0) {
    }

    @Override
    public void start(Environment arg0) throws IOException {
        new Thread((Runnable)this, "WakeupCommand: " + this.name).start();
    }

    @Override
    public void run() {
        int exitValue = 0;
        String exitMessage = null;
        try {
            boolean userAuthNone = Main.userAuthNoneEnabled();
            if (this.name.equals("[osascript, -e, 'tell application \"System Events\" to sleep']") || userAuthNone && this.name.equals("sleep")) {
                log.info("Hybernate windows");
                this.callback(exitValue, exitMessage);
                PowrProf lib2 = PowrProf.INSTANCE;
                boolean isHibernateEnabled = lib2.IsPwrHibernateAllowed();
                boolean hibernatePreferred = SystemTrayFrame.getPrefs(Main.isService()).getBoolean("hibernate", false);
                lib2.SetSuspendState(isHibernateEnabled && hibernatePreferred, true, false);
            } else if (this.name.equals("[osascript, -e, 'tell application \"System Events\" to shut down']") || userAuthNone && this.name.equals("shutdown")) {
                log.info("Shut down windows");
                this.callback(exitValue, exitMessage);
                Runtime.getRuntime().exec("shutdown -s -t 0");
            } else if (this.name.equals("[osascript, -e, 'tell application \"System Events\" to restart']") || userAuthNone && this.name.equals("restart")) {
                log.info("Restarting windows");
                this.callback(exitValue, exitMessage);
                Runtime.getRuntime().exec("shutdown -r -t 0");
            }
        }
        catch (Exception ex) {
            log.warn("Error ", ex);
            throw new RuntimeException("Interrupted", ex);
        }
    }

    private void callback(int exitValue, String exitMessage) {
        if (this.callback != null) {
            this.callback.onExit(exitValue, exitMessage);
        }
    }
}

