/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.Property;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Util;

@MBean(description="Forwards unicast messages to the current coordinator")
public class FORWARD_TO_COORD
extends Protocol {
    @Property(description="The delay (in ms) to wait until we resend a message to member P after P told us that it isn't the coordinator. Thsi can happen when we see P as new coordinator, but P hasn't yet installed the view which makes it coordinator (perhaps due to a slight delay)")
    protected long resend_delay = 500L;
    protected final Map<Long, Message> msgs = new HashMap<Long, Message>();
    protected volatile Address coord = null;
    protected volatile Address local_addr;
    protected long current_id = 0L;

    @Override
    public List<Integer> providedUpServices() {
        return Arrays.asList(105);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 105: {
                Address target = this.coord;
                if (target == null) {
                    throw new IllegalStateException("coord is null; dropping message");
                }
                Message msg = (Message)evt.getArg();
                Long tmp_id = this.getNextId();
                ForwardHeader hdr = new ForwardHeader(1, tmp_id);
                msg.putHeader(this.id, hdr);
                msg.setDest(target);
                Map<Long, Message> map = this.msgs;
                synchronized (map) {
                    this.msgs.put(tmp_id, msg);
                }
                if (this.log.isTraceEnabled()) {
                    this.log.trace(this.local_addr + ": forwarding message with id=" + tmp_id + " to current coordinator " + target);
                }
                return this.down_prot.down(new Event(1, msg));
            }
            case 6: {
                this.handleViewChange((View)evt.getArg());
                break;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
            }
        }
        return this.down_prot.down(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                ForwardHeader hdr = (ForwardHeader)msg.getHeader(this.id);
                if (hdr == null) break;
                long tmp_id = hdr.getId();
                Address sender = msg.getSrc();
                switch (hdr.getType()) {
                    case 1: {
                        if (this.local_addr != null && !this.local_addr.equals(this.coord)) {
                            if (this.log.isWarnEnabled()) {
                                this.log.warn(this.local_addr + ": received a message with id=" + tmp_id + " from " + sender + ", but I'm not coordinator (" + this.coord + " is); dropping the message");
                            }
                            this.sendNotCoord(sender, tmp_id);
                            return null;
                        }
                        try {
                            if (this.log.isTraceEnabled()) {
                                this.log.trace(this.local_addr + ": received a message with id=" + tmp_id + " from " + sender);
                            }
                            Object object = this.up_prot.up(evt);
                            return object;
                        }
                        finally {
                            this.sendAck(sender, tmp_id);
                        }
                    }
                    case 2: {
                        Map<Long, Message> map = this.msgs;
                        synchronized (map) {
                            this.msgs.remove(tmp_id);
                        }
                        if (this.log.isTraceEnabled()) {
                            this.log.trace(this.local_addr + ": received an ack from " + sender + " for " + tmp_id);
                        }
                        return null;
                    }
                    case 3: {
                        Message resend;
                        Map<Long, Message> map = this.msgs;
                        synchronized (map) {
                            resend = this.msgs.get(tmp_id);
                        }
                        if (resend != null) {
                            Message copy = resend.copy();
                            Address target = this.coord;
                            copy.setDest(target);
                            Util.sleep(this.resend_delay);
                            if (this.log.isTraceEnabled()) {
                                this.log.trace(this.local_addr + ": resending message with id=" + tmp_id + " to coord " + target);
                            }
                            this.down_prot.down(new Event(1, copy));
                        }
                        return null;
                    }
                }
                break;
            }
            case 6: {
                this.handleViewChange((View)evt.getArg());
            }
        }
        return this.up_prot.up(evt);
    }

    @Override
    public void stop() {
        super.stop();
        this.msgs.clear();
        this.coord = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedAttribute(description="Number of messages for which no ack has been received yet")
    public int getPendingMessages() {
        Map<Long, Message> map = this.msgs;
        synchronized (map) {
            return this.msgs.size();
        }
    }

    protected synchronized long getNextId() {
        return this.current_id++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleViewChange(View view) {
        Address new_coord = Util.getCoordinator(view);
        boolean coord_changed = this.coord == null || !this.coord.equals(new_coord);
        this.coord = new_coord;
        if (coord_changed) {
            LinkedList<Message> pending_msgs;
            Map<Long, Message> map = this.msgs;
            synchronized (map) {
                if (this.msgs.isEmpty()) {
                    return;
                }
                pending_msgs = new LinkedList<Message>(this.msgs.values());
            }
            if (!pending_msgs.isEmpty()) {
                if (this.log.isTraceEnabled()) {
                    int size = pending_msgs.size();
                    this.log.trace(this.local_addr + ": received view " + view + "; resending " + size + (size > 1 ? " messages" : " message") + " to new coordinator " + this.coord);
                }
                for (Message msg : pending_msgs) {
                    Message copy = msg.copy();
                    copy.setDest(this.coord);
                    try {
                        this.down_prot.down(new Event(1, copy));
                    }
                    catch (Throwable t) {
                        this.log.warn("failed resending message", t);
                    }
                }
            }
        }
    }

    protected void sendAck(Address target, long ack_id) {
        this.send(target, ack_id, (byte)2);
    }

    protected void sendNotCoord(Address target, long ack_id) {
        this.send(target, ack_id, (byte)3);
    }

    protected void send(Address target, long ack_id, byte type) {
        Message msg = new Message(target);
        ForwardHeader hdr = new ForwardHeader(type, ack_id);
        msg.putHeader(this.id, hdr);
        this.down_prot.down(new Event(1, msg));
    }

    protected static class ForwardHeader
    extends Header {
        protected static final byte MSG = 1;
        protected static final byte ACK = 2;
        protected static final byte NOT_COORD = 3;
        protected byte type;
        protected long id;

        public ForwardHeader() {
        }

        public ForwardHeader(byte type, long id) {
            this.type = type;
            this.id = id;
        }

        public long getId() {
            return this.id;
        }

        public byte getType() {
            return this.type;
        }

        @Override
        public int size() {
            return 1 + Util.size(this.id);
        }

        @Override
        public void writeTo(DataOutput out) throws Exception {
            out.writeByte(this.type);
            Util.writeLong(this.id, out);
        }

        @Override
        public void readFrom(DataInput in) throws Exception {
            this.type = in.readByte();
            this.id = Util.readLong(in);
        }

        @Override
        public String toString() {
            return ForwardHeader.typeToString(this.type) + "(" + this.id + ")";
        }

        protected static String typeToString(byte type) {
            switch (type) {
                case 1: {
                    return "MSG";
                }
                case 2: {
                    return "ACK";
                }
                case 3: {
                    return "NOT_COORD";
                }
            }
            return "n/a";
        }
    }
}

